
/*******************************************************************************/
/*  
	This script categorizes occupations as essential or non-essential.
	Using DHS classification from Tomer and Cain 2020.
	https://www.brookings.edu/research/how-to-protect-essential-workers-during-covid-19/
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/


/*----------------------------------------------------*/
	/* [>   DHS Industry Classification   <] */ 
/*----------------------------------------------------*/

import delimited "../Raw Data/DHS/essential_work.csv", varnames(1) clear

merge 1:m naics using "../Data/OES/oes_ind_clean.dta"		// merge in OES / ONET
gen essential = !mi(dhs_cat)							// mark essential industries, 4digit NAICS

merge m:1 oes2019 using "../Raw Data/Crosswalks/oessoc2010_to_occuh_xwalk.dta", keep(match) nogen 	

//__________________________________________________________
// Collapse 3digit
preserve
	collapse (mean) share_essential=essential [w=tot_emp], by(occ) // compute share of each occ in essential industries
	save "../Data/DHS/occ3digit_essential", replace
restore
	
//__________________________________________________________
// Collapse 2digit
preserve
	collapse (mean) share_essential=essential [w=tot_emp], by(occ_2digit) // compute share of each occ in essential industries
	save "../Data/DHS/occ2digit_essential", replace
restore
